require( "quest/m1_dresspanel/convout.lua" );
combine_speech_tables();

code_string = "";
correct_code_string = "102030";
code_string_max = 6;
code_string_count = 0;

flo_spec =
{
	name = "FLO";
	--gfx = { image = "quest/shared/help_panel" };
	
	command = function(actor)
		--actor:JumpToPoint { x = 0, y = 0 };
		--actor:SetDepthMode(DEPTH.DEPTH_OVER_HUD);
		--actor:ModifySaySpec
		--{
		--	colour = { a = 1, r = 1, g = 1, b = 1 };
		--	y = 540,
		--	x = 150,
		--	w = 500,
		--	h = 100,
		--	bubble = false,
		--	outline_size = 0,
		--	anchor = ANCHOR.TOP,
		--	halign = HALIGN.LEFT,
		--};
		
		if game:Get("first_time_dress_panel") < 1 then
			-- do any intro here
			game:Set("first_time_dress_panel", 1);
		end
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
};

panel_spec = 
{
	name = "PANEL";
	halo = "panel";
	
	command = function(actor)
		actor:SetDepthValue(1);
		if game:Get("beadmachine_panel_open") < 1 then
			actor:LoadImage("panel_closed");
			spawn_screws();
		else
			actor:LoadImage("panel_open");
			scene:Spawn(enter_button_spec);
			scene:Spawn(light_spec);
			scene:Spawn(display_spec);
			spawn_buttons();
		end
	end;
	
	on_use_inv = function(item, flo, panel)
		if item == "screwdriver" then
			return RESPONSE.INV_HANDLED;
		else
			return RESPONSE_INV_UNHANDLED;
		end
	end
}

panel_text_spec = 
{
	name = "PANEL_TEXT";
	
	command = function(actor)
			actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
			actor:AddFlag(AFLAG.AFLAG_NO_VOX);
			actor:SetDepthValue(15);
			actor:ModifySaySpec
			{
				color = { a = 0.5, r = 1, g = 1, b = 1 },
				y = 75,
				x = 210,
				w = 650,
				h = 600,
				bubble = false,
				lineheight = 36,
				outline_size = 0,
				fixed = true,
				font = "fonts/arial.mvec"; 
				anchor = ANCHOR.TOP;
				halign = HALIGN.LEFT;
			};
			actor:Say("text_beadomatic_panel");
			--actor:AltTextToImage();
		end;
};

function user_screwdriver(flo)
	local panel_unscrewed = true;
	for i = 1,4 do
		if game:Get("dress_panel_screw_" .. i ) < 1 then
			panel_unscrewed = false;
			break;
		end
	end
	
	if panel_unscrewed then
		flo:StartProc(open_panel);
	end
end;

function open_panel(flo)
	sfx:PlaySFX("audio/sfx/panel_open.ogg");
	game:Set("beadmachine_panel_open", 1);
	scene.PANEL:LoadImage("panel_open");
	scene.PANEL_TEXT:Expire();
	BAG_INV:RemoveInventory("screwdriver");
	scene:Spawn(enter_button_spec);
	scene:Spawn(light_spec);
	scene:Spawn(display_spec);
	spawn_buttons();
end

function spawn_screws()
	for i = 1,4 do
		if game:Get("dress_panel_screw_" .. i) < 1 then
			spawn_screw(i);
			spawn_screw_highlight(i);
		end
	end
end;

function spawn_screw(screw_num)
	return scene:Spawn
	{
		name = "SCREW_" .. screw_num;
		halo = "screw_" .. screw_num;
		gfx = { image = "screw_" .. screw_num };
		
		command = function(actor)
			actor:SetDepthValue(100);
			
			actor.on_use_inv = function(item, flo, screw)
				if item == "screwdriver" then
					game:Set("dress_panel_screw_" .. screw_num, 1);
					sfx:PlaySFX("audio/sfx/panel_unscrew");
					user_screwdriver(flo);
					screw:Expire();
					scene["SCREW_HIGHLIGHT_" .. screw_num]:Expire();
				end
			end;
			
			actor.point_at_fn = function(actor, enter)
				if enter then
					scene["SCREW_HIGHLIGHT_" .. screw_num]:SetAlpha(1);
				else
					scene["SCREW_HIGHLIGHT_" .. screw_num]:SetAlpha(0);
				end
			end;
		end;
	};
end

function spawn_screw_highlight(screw_num)
	return scene:Spawn
	{
		name = "SCREW_HIGHLIGHT_" .. screw_num;
		gfx = { image = "screw_" .. screw_num .. "hilight" };
		
		command = function(actor)
			actor:SetDepthValue(101);
			actor:SetAlpha(0);
		end;
	};
end

function check_code(flo)

end

function push_enter(button)
	scene.FLO:SetMode(MODE.CUTSCENE);
	button:LoadImage("enter_btn_down");
	button:ModifySaySpec
	{
		x = 430,
		y = 174,
	};
	
	if code_string == correct_code_string then
		scene.LIGHT:LoadImage("light_green");
		game:Set("beadmachine_fixed", 1);
		sfx:PlaySFX("audio/sfx/enter_correct");
		delay(30);
		scene:ReturnFromScene();
	else
		scene.DISPLAY:SayRaw("######");
		sfx:PlaySFX("audio/sfx/enter_wrong");
		code_string_count = 0;
	end;
	
	delay(10);
	if button.over then
		button:LoadImage("enter_btn_highlight");
	else
		button:LoadImage("enter_btn_up");
	end
	button:ModifySaySpec
	{
		x = 433,
		y = 177,
	};
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
end

enter_button_spec = 
{
	name = "ENTER_BUTTON";
	halo = "enter_button";
	gfx = { image = "enter_btn_up" };
	
	command = function(actor)
		actor:SetPointAtCursor("cursor");
		actor:ModifySaySpec
		{
			color = { a = 0.7, r = 0, g = 0, b = 0 },
			x = 433,
			y = 177,
			w = 250,
			h = 80,
			bubble = false,
			outline_size = 0,
			lineheight = 40,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER
		};
		actor:Say("enter");
		actor.over = false;
	end;
	
	on_click = function(flo, enter_button)
		--enter_button:LoadImage("enter_btn_down");
		enter_button:StartProc(push_enter);
	end;
	
	point_at_fn = function(actor, enter)
		if enter then
			actor.over = true;
			actor:LoadImage("enter_btn_highlight");
		else
			actor.over = false;
			actor:LoadImage("enter_btn_up");
		end
	end;
}

light_spec = 
{
	name = "LIGHT";
	
	command = function(actor)
		if game:Get("beadmachine_fixed") < 1 then
			actor:LoadImage("light_red");
		else
			actor:LoadImage("light_green");
		end
	end;
}

display_spec = 
{
	name = "DISPLAY";
	
	command = function(actor)
		actor:ModifySaySpec
		{
			color = { a = 0.6, r = 0, g = 0, b = 0 },
			x = 180,
			y = 140,
			w = 250,
			h = 80,
			bubble = false,
			outline_size = 0,
			lineheight = 50,
			font = "fonts/franklingothic_demicond.mvec"; 
			anchor = ANCHOR.CENTER,
			halign = HALIGN.RIGHT
		};
		
		actor:SayRaw("######");
	end;
}

local buttonPos = { x = 255, y = 205 };
local buttonOffset = { x = 45, y = 45 };

local buttons = 
{
	{ x = buttonPos.x + (buttonOffset.x * 0), y = buttonPos.y + (buttonOffset.y * 0) },
	{ x = buttonPos.x + (buttonOffset.x * 1), y = buttonPos.y + (buttonOffset.y * 0) },
	{ x = buttonPos.x + (buttonOffset.x * 2), y = buttonPos.y + (buttonOffset.y * 0) },
	{ x = buttonPos.x + (buttonOffset.x * 0), y = buttonPos.y + (buttonOffset.y * 1) },
	{ x = buttonPos.x + (buttonOffset.x * 1), y = buttonPos.y + (buttonOffset.y * 1) },
	{ x = buttonPos.x + (buttonOffset.x * 2), y = buttonPos.y + (buttonOffset.y * 1) },
	{ x = buttonPos.x + (buttonOffset.x * 0), y = buttonPos.y + (buttonOffset.y * 2) },
	{ x = buttonPos.x + (buttonOffset.x * 1), y = buttonPos.y + (buttonOffset.y * 2) },
	{ x = buttonPos.x + (buttonOffset.x * 2), y = buttonPos.y + (buttonOffset.y * 2) },
	{ x = buttonPos.x + (buttonOffset.x * 1), y = buttonPos.y + (buttonOffset.y * 3) },
};

function spawn_buttons()
	for i,v in pairs(buttons) do
		if i == 10 then
			scene:Spawn(spawn_button_spec("0", v.x, v.y, 20));
		else
			scene:Spawn(spawn_button_spec(tostring(i), v.x, v.y, 20));
		end
	end
end

function spawn_button_spec(_name, _x, _y, _depth)
	return
	{
		name = _name;
		halo = "button";
		gfx = { image = "key_btn_up" };
		
		command = function(actor)
			actor:JumpToPoint { x = _x, y = _y };
			actor:SetDepthValue(_depth);
			actor:SetPointAtCursor("cursor");
			actor:ModifySaySpec
			{
				color = { a = .5, r = 0, g = 0, b = 0 },
				x = 0,
				y = 27,
				w = 50,
				h = 50,
				bubble = false,
				outline_size = 0,
				lineheight = 40,
				font = "fonts/franklingothic_demicond.mvec"; 
				anchor = ANCHOR.CENTER
			};
			actor.number_value = _name;
			actor:SayRaw(_name);
			actor.over = false;
		end;
		
		on_click = function(flo, button)
			button:StartProc(push_key);
		end;
		
		point_at_fn = function(actor, enter)
			if enter then
				actor.over = true;
				actor:LoadImage("key_btn_highlight");
			else
				actor.over = false;
				actor:LoadImage("key_btn_up");
			end
		end;
	}
end

function push_key(button)
	scene.FLO:SetMode(MODE.CUTSCENE);
	button:LoadImage("key_btn_down");
	sfx:PlaySFX("audio/sfx/button_beep");
	button:ModifySaySpec
	{
		x = 2,
		y = 25,
	};
	if code_string_count == 0 then
		code_string = "";
	end
	
	if code_string_count < code_string_max then
		code_string = code_string .. button.number_value;
		code_string_count = code_string_count + 1;
		scene.DISPLAY:SayRaw(code_string);
	end
	delay(10);
	if button.over then
		button:LoadImage("key_btn_highlight");
	else
		button:LoadImage("key_btn_up");
	end
	button:ModifySaySpec
	{
		x = 0,
		y = 27,
	};
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
end

back_spec = 
{
	name = "BACK";
	halo = "background";
	--point_at_name = "back";
	point_at_color = { a  = 1, r = 1, g = 0, b = 0 };
	
	command = function(actor)
		actor:SetDepthValue(0);
		actor:SetPointAtCursor("cursor_exit");
	end;
	
	on_arrive = function(flo, actor)
		scene:ReturnFromScene();
	end;
	
	on_use_inv = function(item, flo, actor)
		scene:ReturnFromScene();
		game:ClearInvUsage();
		return RESPONSE.INV_HANDLED;
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/dressshopmusic.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up(true, true);
		
		if IsCheatMode() then
			-- testing data
			--BAG_INV:AddInventory(inv_desc_screwdriver);
		end
		
		if game:Get("beadmachine_panel_open") < 1 then
			scene:Spawn(panel_text_spec);
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
		"clothes1",
	};
	
	bg_image = 
	{
		{ "panel_closed", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		scene_setup,
		flo_spec, -- the main actor
		panel_spec,
		back_spec,
	};
};
